"use client";
import React from "react";
import { Globe } from "lucide-react";
import { useLanguage } from "@/contexts/LanguageContext";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";

type Language = "en" | "it";

const languages: Record<Language, { name: string; flag: string }> = {
  en: { name: "English", flag: "🇬🇧" },
  it: { name: "Italiano", flag: "🇮🇹" },
};

export default function LanguageSwitcher() {
  const { language, setLanguage } = useLanguage();

  const handleLanguageChange = (lang: Language) => {
    setLanguage(lang);
  };

  return (
    <DropdownMenu>
      <DropdownMenuTrigger asChild>
        <button className='flex items-center justify-center h-9 w-9 rounded-md text-foreground/80 hover:text-foreground hover:bg-sidebar-accent transition-colors'>
          <Globe className='h-5 w-5' />
          <span className='sr-only'>Change language</span>
        </button>
      </DropdownMenuTrigger>
      <DropdownMenuContent align='end' className='w-48 bg-popover'>
        {Object.entries(languages).map(([lang, info]) => (
          <DropdownMenuItem
            key={lang}
            onClick={() => handleLanguageChange(lang as Language)}
            className={`cursor-pointer ${
              language === lang ? "bg-accent font-medium" : ""
            }`}
          >
            <span className='mr-2 text-lg'>{info.flag}</span>
            <span>{info.name}</span>
            {language === lang && (
              <span className='ml-auto text-primary-600 dark:text-primary-400'>
                ✓
              </span>
            )}
          </DropdownMenuItem>
        ))}
      </DropdownMenuContent>
    </DropdownMenu>
  );
}
